<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;
use Illuminate\Database\Eloquent\SoftDeletes;

class Blog extends Model
{
    use HasFactory;
    use SoftDeletes;

    protected $dates = ['deleted_at'];

    protected $fillable = [
        'user_id',
        'website_id',
        'category_id',
        'image',
        'title',
        'meta_title',
        'meta_description',
        'content',
        'description',
        'slug',
        'schedule_at',
        'pricePlan',
        'expire_at'
    ];

    public function user()
    {
        return $this->belongsTo(User::class);
    }

 

    public function category()
    {
        return $this->belongsTo(Category::class);
    }
}
