<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Model;
use Illuminate\Database\Eloquent\SoftDeletes;
use Illuminate\Database\Eloquent\Factories\HasFactory;

class ProductVariant extends Model
{
    use HasFactory;
  use SoftDeletes;

    protected $dates = ['deleted_at'];


     protected $fillable = [
        'product_id',
        'name',
        'attribute',
        'price',
        'stock',
        'sku',
    ];

    /**
     * Relationships
     */
    
    // A variant belongs to a product
    public function product()
    {
        return $this->belongsTo(Product::class);
    }
}
