<?php

namespace App\Services;

use GuzzleHttp\Client;
use GuzzleHttp\Exception\RequestException;

class BunnyCDNService
{
    protected $client;
    protected $zoneName;
    protected $accessKey;
    protected $urlPrefix;

    public function __construct()
    {
        $this->client = new Client();
        $this->zoneName = config('services.bunnycdn.zone_name');
        $this->accessKey = config('services.bunnycdn.access_key');
        $this->urlPrefix = config('services.bunnycdn.url_prefix');

    }

    public function uploadImage($localImagePath, $remoteFileName)
    {
        // Check if the local image file exists and is readable
        if (!file_exists($localImagePath) || !is_readable($localImagePath)) {
            throw new \Exception("The file {$localImagePath} does not exist or is not readable.");
        }

        try {
            // Upload the file using a PUT request
            $response = $this->client->request('PUT', "https://storage.bunnycdn.com/{$this->zoneName}/{$remoteFileName}", [
                'headers' => [
                    'AccessKey' => $this->accessKey,
                ],
                'body' => fopen($localImagePath, 'r'),
            ]);

            // Check if the response status code is 201 (Created)
            if ($response->getStatusCode() == 201) {
                return $this->urlPrefix . ltrim($remoteFileName, '/');
            }

            // Handle other status codes
            throw new \Exception("Upload failed with status code: " . $response->getStatusCode());
        } catch (RequestException $e) {
            // Catch any request exceptions from Guzzle and handle them
            throw new \Exception("Error during upload: " . $e->getMessage());
        } catch (\Exception $e) {
            // Catch any other exceptions
            throw new \Exception("An error occurred: " . $e->getMessage());
        }
    }
}
