<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    /**
     * Run the migrations.
     */
    public function up(): void
    {
        Schema::create('product_variants', function (Blueprint $table) {
            $table->id();
            $table->unsignedBigInteger('product_id'); // Foreign key for product
            $table->string('name')->nullable(); // Variant name (e.g., Red, Large)
            $table->string('attribute')->nullable(); // Attribute type (e.g., Color, Size)
            $table->decimal('price', 10, 2)->nullable(); // Additional price for this variant
            $table->integer('stock')->default(0); // Stock for the specific variant
            $table->string('sku')->unique()->nullable(); // SKU for the variant
            $table->timestamps();
            $table->softDeletes();

            // Foreign key constraints
            $table->foreign('product_id')->references('id')->on('products')->onDelete('cascade');
        });
    }

    /**
     * Reverse the migrations.
     */
    public function down(): void
    {
        Schema::dropIfExists('product_variants');
    }
};
