<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    /**
     * Run the migrations.
     */
    public function up(): void
    {
         Schema::create('pixels', function (Blueprint $table) {
            $table->id();
            $table->string('platform'); // google, facebook, snapchat, tiktok
            $table->json('pixel_id'); // Store multiple pixel IDs as JSON
            $table->string('conversion_type')->nullable();
            $table->timestamps();
            $table->softDeletes();

        });
    }

    /**
     * Reverse the migrations.
     */
    public function down(): void
    {
        Schema::dropIfExists('pixels');
    }
};
